/* Copyright (c) 2007 Analog Devices, Inc. All rights reserved.

ADI_CED1_dll.h and ADI_CED1_dll.c can be used to explicitly link 
to ADI_CED1a.dll

*/

#ifndef ADI_CED1_DLL
#define ADI_CED1_DLL

/* Exclude rarely-used stuff from Windows headers */
#define WIN32_LEAN_AND_MEAN 
#include<Windows.h>

/* define function pointers used to make calls to the ADI_CED1a.dll */

typedef long (__stdcall *SEARCH_FOR_BOARDS)
(
	long *number_boards, 
	unsigned long board_ids[]
);

typedef long (__stdcall *PROGRAM_BOARD)
(
	unsigned long board_id, 
	const char *ptrFPGAfiles
);

typedef long (__stdcall *IDENTIFY_BOARD)
(
	unsigned long board_id
);

typedef long (__stdcall *CONFIGURE_POWER_SUPPLIES)
(
	unsigned long board_id,
	long vara,
	long vard,
	long vio,
	unsigned short supplies_on
);

typedef long (__stdcall *READ_POWER_SUPPLIES)
(
	unsigned long board_id,
	double array[], 
	unsigned long length
);

typedef long (__stdcall *CHECK_DATA_READY)
(
	unsigned long board_id,
	long *ready
);

typedef long (__stdcall *RESET)
(
	unsigned long board_id
);

typedef long (__stdcall *MANUAL_SEND_TO_CED)
( 
	unsigned long board_id, 
	unsigned short command, 
	unsigned short send_array[], 
	unsigned long size_of_send_array
);

typedef long (__stdcall *MANUAL_RECEIVE_FROM_CED)
( 
	unsigned long board_id,
	unsigned short command,
	unsigned short receive_array[],
	unsigned long size_of_receive_array
);

/* define structure to hold function pointers (and handle to dll) */
typedef struct
{
	HINSTANCE                  hdll;
	SEARCH_FOR_BOARDS          search_for_boards;
	PROGRAM_BOARD              program_board;
	IDENTIFY_BOARD             identify_board;
	CONFIGURE_POWER_SUPPLIES   configure_power_supplies;
	READ_POWER_SUPPLIES        read_power_supplies;
	CHECK_DATA_READY           check_data_ready;
	RESET                      reset;
	MANUAL_SEND_TO_CED         manual_send_to_ced;
	MANUAL_RECEIVE_FROM_CED    manual_receive_from_ced;
}ADI_CED1;

/* function decelerations for functions in ADI_CED1_dll.c */

/* link_to_adi_ced1_dll() is used to explicitly link to the ADI_CED1a.dll. It
   loads the libary and fills the ced structure with a handle to the dll and
   and function pointers to all the exposed functions of the dll. If an error
   is encountered TRUE is returned with FALSE returned if the link was 
   successful. */
long link_to_adi_ced1_dll( ADI_CED1 *ced );

/* free_adi_ced1_dll() frees the handle to ADI_CED1a.dll created by
   link_to_adi_ced1_dll() */
void free_adi_ced1_dll( ADI_CED1 ced );

#endif
